#include "Main.h"

void InitWinConsole(Game *g)
{
	int i;
	CHAR_INFO *ci;
	WinConsole *c;
	assert(g != NULL);
	c = &(g->con);

	// Set up the handles for reading/writing:
	c->wHnd = GetStdHandle(STD_OUTPUT_HANDLE);
   c->rHnd = GetStdHandle(STD_INPUT_HANDLE);

	c->updating = 0;
	c->cursorPos.X = 0;
	c->cursorPos.Y = 0;

   // Change the window title:
	//SetConsoleTitleW(L"");

   // Set up the required window size:
	c->windowSize.Left = 0;
	c->windowSize.Top = 0;
	c->windowSize.Right = 79;
	c->windowSize.Bottom = 24;

	c->consoleStart = gameHeight+4;
	c->consoleY = c->consoleStart;
	c->consoleX = 0;
	c->consoleEnd = c->windowSize.Bottom - 1;
	assert (c->consoleEnd - c->consoleStart >= 2);
    
   // Change the console window size:
	SetConsoleWindowInfo(c->wHnd, TRUE, &(c->windowSize));
    
   // Create a COORD to hold the buffer size:
	c->bufferSize.X = 80;
	c->bufferSize.Y = 25;

   // Change the internal buffer size:
   SetConsoleScreenBufferSize(c->wHnd, c->bufferSize);

   // Set up the character:
	ci = c->buf;
	for (i=0; i<25*80; i++)
	{
		ci->Attributes = ATTS_DEFAULT;
		ci->Char.AsciiChar = 0;
		ci->Char.UnicodeChar = 0;
		ci++;
	}

	ci = c->buf;
	//(ci+255)->Char.AsciiChar = 'x';
    
    //letterA->Attributes = 
	//	 FOREGROUND_RED | FOREGROUND_INTENSITY | BACKGROUND_BLUE | BACKGROUND_GREEN | BACKGROUND_RED;

    // Set up the positions:
	 c->charBufSize.X = 80;
	 c->charBufSize.Y = 25;
	 c->characterPos.X = c->characterPos.Y = 0;
	 c->writeArea.Left = c->writeArea.Top = 0;
	 c->writeArea.Right = 79; c->writeArea.Bottom = 24;

    // Write the character:
	 SetConsoleCP(65001); // utf-8
    WriteConsoleOutputA(c->wHnd, c->buf, c->charBufSize, c->characterPos, &(c->writeArea));

	 /*i = 0;
	 x = 0;
	 while (1)
	{
		//(ci+i)->Char.AsciiChar = 0;
		while ((ci+i)->Char.AsciiChar == 'X') i = rand()% (25*80);
		(ci+i)->Char.AsciiChar = 'X';
		WriteConsoleOutputA(c->wHnd, c->buf, c->charBufSize, c->characterPos, &(c->writeArea));
		x++;
		if (x == 80*25) return;
	}*/

    // Move the cursor down a row so we can see the character:
    //printf("\n");
}
void WinConsoleUpdate(WinConsole *c)
{
	assert (c != NULL);
	if (c->updating) return;
	WriteConsoleOutput(c->wHnd, c->buf, c->charBufSize, c->characterPos, &(c->writeArea));
}
void WinConsoleBegin(WinConsole *c)
{
	assert (c != NULL);
	assert(c->updating == 0);
	c->updating = 1;
}
void WinConsoleEnd(WinConsole *c)
{
	assert (c != NULL);
	assert(c->updating == 1);
	c->updating = 0;
	WinConsoleUpdate(c);
}

CHAR_INFO *GetConBuf(WinConsole *wc, int x, int y)
{
	return (wc->buf)+((x + (y*wc->bufferSize.X)));
}

void printfxy(Game *g, int x, int y, int atts, const char *format, ...)
{
	CHAR_INFO *ci;
	va_list args;
	char buf[256];
	char *pc;

	va_start(args, format);
	if (*args == '$') sprintf(buf, format);
	else vsprintf(buf, format, args);
	va_end(args);

	for (pc = buf; *pc != '\0'; pc++)
	{
		ci = GetConBuf(&(g->con),x,y);
		ci->Char.AsciiChar = *pc;		
		if (atts != -1) ci->Attributes = (WORD)atts;
		else ci->Attributes = ATTS_DEFAULT;
		x++;
		if (x >= g->con.bufferSize.X)
		{
			x = 0;
			y++;
		}
		//g->con.buf[x + (y*g->con.bufferSize.X)].Char.UnicodeChar = 0;
	}

	if (!g->con.updating) WinConsoleUpdate(&(g->con));
}

void UpdateWinCursor(WinConsole *wc)
{
	assert (wc != NULL);
	assert (wc->cursorPos.X <= wc->bufferSize.X);
	assert (wc->cursorPos.Y <= wc->bufferSize.Y);
	SetConsoleCursorPosition(wc->wHnd, wc->cursorPos);
}

void scrollWinConsole(WinConsole *wc)
{
	int y;
	CHAR_INFO *ci;
	assert (wc != NULL);	
	assert (wc->updating == 1); // it's a good idea to call WinConsoleBegin() before this function
	if (wc->consoleY < wc->consoleEnd) return;
	for (y=wc->consoleStart+1; y<=wc->consoleEnd+1; y++)
	{
		memcpy(
			(wc->buf) + (((y-1)*wc->bufferSize.X)),
			(wc->buf) + ((y*wc->bufferSize.X)),
			wc->bufferSize.X * sizeof (CHAR_INFO)
		);
	}
	for (y=0; y<wc->bufferSize.X; y++)
	{
		ci = GetConBuf(wc, y, wc->consoleEnd+1);
		ci->Attributes = ATTS_DEFAULT;
		ci->Char.AsciiChar = 0;
	}
	wc->consoleY--;
	wc->cursorPos.Y--;
	UpdateWinCursor(wc);
}

// Since we are using raw console access, there is no echo
// after the user presses Enter. We have print the echo
// manually.
void consoleInputWin(WinConsole *con, char *buf, int buflen)
{
	fgets(buf, buflen, stdin);
	con->consoleX = 0;
	printfCon(con, "> %s", buf);
	con->consoleX = 0;
	if (*buf == '-') exit(0);
}

void printfCon(WinConsole *wc, const char *format, ...)
{
	CHAR_INFO *ci;
	char buf[256];
	char *pc;
	va_list args;
	int x = 0;
	assert (wc != NULL && format != NULL);

	va_start(args, format);
	/*if (*args == '$') sprintf(buf, format);
	else*/ vsprintf(buf, format, args);
	va_end(args);

	WinConsoleBegin(wc);

	for (pc = buf; *pc != '\0'; pc++)
	{
		if (*pc != '\n')
		{
			if (*pc == '\t') *pc=' ';
			ci = GetConBuf(wc,wc->consoleX,wc->consoleY);
			ci->Char.AsciiChar = *pc;		
			/*if (atts != -1) ci->Attributes = (WORD)atts;
			else */ci->Attributes = ATTS_DEFAULT;
		}
		wc->consoleX++;
		if (wc->consoleX >= wc->bufferSize.X || *pc == '\n')
		{
			wc->consoleX = 0;
			wc->consoleY++;
			while (wc->consoleY > wc->consoleEnd) scrollWinConsole(wc);
		}
		//g->con.buf[x + (y*g->con.bufferSize.X)].Char.UnicodeChar = 0;
	}
	wc->cursorPos.X = 2;
	wc->cursorPos.Y = wc->consoleY;

	while (wc->consoleY > wc->consoleEnd) scrollWinConsole(wc);
	
	UpdateWinCursor(wc);
	WinConsoleEnd(wc);
}

void printMapWinInternal(Game *g, unsigned char *map, int ox, int oy, View v)
{
	char buf[32];
	int x,y,val;
	char c; int atts;
	assert (g != NULL);
	assert (map != NULL);
	assert (ox >= 0 && oy >= 0);

	x = y = 0;

	printfxy(g,ox+x+2,oy+y,-1,"|");
	for (x=0; x<gameWidth; x++) printfxy (g,ox+x+3,oy+y,-1,"%c", 'A'+x);
	y++;
	printfxy(g,ox,oy+y,-1,"--+");
	for (x=0; x<gameWidth; x++) printfxy (g,ox+x+3,oy+y,-1,"%c", '-');
	y++;
	for (y=0; y<gameHeight; y++)
	{
		printfxy (g,ox,oy+y+2,-1,"%2d|", y+1);
		for (x=0; x<gameWidth; x++)
		{
			c = 'O';
			atts = ATTS_DEFAULT;
			val = mapGet(map,x,y);

			if (v == player || v == opponent || v == playerPlacement)
			{
				if (val & F_SUNK)
				{
					c ='#';
					atts = ATTS_DEFAULT | BACKGROUND_BLUE;
				}
				else if ((val & (F_SHIP_PRESENT | F_SHOT_FIRED)) == (F_SHIP_PRESENT | F_SHOT_FIRED) )
				{
					atts = ATTS_DEFAULT | BACKGROUND_RED | BACKGROUND_INTENSITY;
				}
				else if (v != opponent && (val & F_SHIP_PRESENT)) { c = 'O'; atts = ATTS_DEFAULT;}
				else if (val & F_SHOT_FIRED) 
				{
					c = ' ';
					atts = ATTS_DEFAULT | BACKGROUND_GREEN | BACKGROUND_RED;
				}
				else c = ' ';

				if ((v == playerPlacement) && (val & F_NEIGHBOURING) && !(val & F_SHIP_PRESENT))
				{
					c = ' ';
					atts = ATTS_DEFAULT | BACKGROUND_GREEN | BACKGROUND_RED;
				}

				printfxy(g,ox+x+3,oy+y+2,atts,"%c",c);
			}
			else if (v == debug)
			{
				MapCoordsToGrid(val,0,buf,sizeof(buf));
				printfxy(g,ox+x+3,oy+y+2,atts,"%c",  *buf );
			}
		}
	}
}

void printMapWin(Game *g, View playerView, View opponentView)
{
	int ox, oy;

	int x,y;

	assert (g != NULL);
	assert (g->mapOpponent != NULL);
	assert (g->mapPlayer != NULL);

	WinConsoleBegin(&(g->con));

	// print player's map
	x = y = 0;
	ox = oy = 0;
	printMapWinInternal(g, g->mapPlayer,0,0,playerView);

	printMapWinInternal(g, g->mapOpponent,gameWidth+3+5,0,opponentView);
	
	WinConsoleEnd(&(g->con));
}