#include "Main.h"

void gameInit(Game *g)
{
	COORD charBufSize = {1,1};
   COORD characterPos = {0,0};
   SMALL_RECT writeArea = {0,0,0,0}; 

	g->aiHitx  = -1;
	g->aiHity  = -1;
	g->aiState = 0;
	g->aiLuckyShots = numAiLuckyShots;

	assert(g != NULL);
	g->mapPlayer = (unsigned char*) malloc(gameHeight * gameWidth * sizeof(char));
	g->mapOpponent = (unsigned char*) malloc(gameHeight * gameWidth * sizeof(char));
	memset(g->mapPlayer, 0, gameHeight * gameWidth);
	memset(g->mapOpponent, 0, gameHeight * gameWidth);
	g->opponentWon = g->playerWon = 0;
	
	InitWinConsole(g);

	g->shipsToPlace = NULL; /* we're not initing it yet. it will be done by both
									   the placement of player ships and placement of computer
										ships because we need to place ships two times. */
}

void gameClose(Game *g)
{
	assert(g != NULL);
	free(g->mapOpponent);
	free(g->mapPlayer);
	if (g->shipsToPlace != NULL) shipsToPlaceClose(g); // in case we forgot to do it earlier
}

int testVictoryCondition(Game *g)
{
	assert(g != NULL);
	if (!areThereAnyShipsSurviving(g->mapOpponent)) g->playerWon = 1;
	return g->playerWon;
}

int testDefeatCondition(Game *g)
{
	assert(g != NULL);
	if (!areThereAnyShipsSurviving(g->mapPlayer)) g->opponentWon = 1;
	return g->opponentWon;
}

void doPlayersTurn(Game *g)
{
	char buf[256];
	int x,y,res;
	int shotsLeft = shotsPerTurn;
	assert (g != NULL);

	while (shotsLeft > 0)
	{
		printMapWin(g, player, opponent);
		printfCon (&(g->con),"You have %d shot%s left. What is your target?\n> ",
			shotsLeft, shotsLeft == 1? "" : "s");
		//fgets(buf, sizeof(buf), stdin);
		//g->con.consoleX = 0;
		//printfCon(&(g->con), "> %s", buf);
		//g->con.consoleX = 0;
		//if (*buf == '-') exit(0);
		consoleInputWin(&(g->con), buf, sizeof(buf));
		stringToLower(buf, strlen(buf));
		res = parseGridSquare(buf, strlen(buf), &x, &y);
		if (!res)
		{
			printfCon (&(g->con), "Bad coordinates. Try again!\n> ");
			continue;
		}
		res = Shoot(g->mapOpponent, x, y, &(g->con));
		if (res == -1)
		{
			printfCon (&(g->con), "Not firing at the same spot twice.\n> ");
			continue;
		}
		if (res == 2) testVictoryCondition(g);
		shotsLeft--;
		if (g->playerWon) break;
	}
}

void MainLoop(Game *g)
{
	assert(g != NULL);
	while (1)
	{
		doPlayersTurn(g);
		if (g->playerWon)
		{
			printfCon (&(g->con), "You Won!\nCongratulations!\n\n");
			break;
		}
		doOpponentsTurn(g);
		printMapWin(g, player, opponent);
		if (g->opponentWon) {printfCon (&(g->con), "The Opponent Won!\nTry again?\n\n"); break; }
		//printMap(g->mapPlayer, player);
		//printfCon (&(g->con), "Press enter to continue...\n> ");
		//getchar();
	}
	printMapWin(g, player, player);
}