#include "Main.h"

const int numSizeFiveShips = 1;
const int numSizeFourShips = 2;
const int numSizeThreeShips = 3;
const int numSizeTwoShips = 4;
const int maxShipLen = 5;
const int shotsPerTurn = 3;

const int gameWidth = 10;
const int gameHeight = 10;

const int numAiLuckyShots = 5;

int main(int argc, char *argv[])
{
	char buf[256];
	Game g;
	int choice;

	while (1)
	{
		choice = 0;

		gameInit(&g);
		printMapWin(&g, player, opponent);
		srand((unsigned int)time(NULL)); // initialize the RNG with current time

		do
		{
			printfCon(&(g.con), "Select Your Opponent (type a number 1-4)\n"
				"\t1 - Not The Brightest Bulb (Easy)\n"
				"\t2 - Adept (Medium)\n"
				"\t3 - Expert (Hard)\n"
				"\t4 - Champion (Hard, Lucky)\n\n> "
				);
			//fgets(buf, sizeof(buf), stdin);
			consoleInputWin(&(g.con), buf, sizeof(buf));
			parseNumber(buf, strlen(buf), &choice);
		}
		while (choice < 1 || choice > 4);

		switch (choice)
		{
			case 1: doOpponentsTurn = stupidAITurn; break;
			case 2: doOpponentsTurn = adeptAITurn; break;
			case 3: doOpponentsTurn = ExpertAITurn; break;
			default: doOpponentsTurn = CheatingAITurn; break;
		}

		do
		{
			printfCon(&(g.con), "Are you going to place your ships yourself, or would you like them "
				"to be placed randomly?\n 1 - Place yourself\n 2 - Place randomly\n\n> "
				);
			consoleInputWin(&(g.con), buf, sizeof(buf));
			parseNumber(buf, strlen(buf), &choice);
		}
		while (choice != 1 && choice != 2);

		if (choice == 1) placePlayersShips(&g);
		else placeOpponentsShips(&g, g.mapPlayer);

		placeOpponentsShips(&g, g.mapOpponent);

		MainLoop(&g);

		gameClose(&g);
		
		do
		{
			printfCon(&(g.con), "Another game?\n 1 - keep playing\n 2 - quit\n\n> ");
			consoleInputWin(&(g.con), buf, sizeof(buf));
			parseNumber(buf, strlen(buf), &choice);
		}
		while (choice != 1 && choice != 2);

		if (choice == 2) return 0;
	}
}

